<?php
/* Rupantorpay WHMCS Plugin
 *
 * Copyright (c) 2025 rupantorpay
 * Website: https://rupantorpay.com/
 * Developer: https://github.com/rupantorpay
 * 
 */

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

function rupantorpay_MetaData()
{
    return array(
        'DisplayName' => 'Rupantorpay',
        'APIVersion' => '1.0',
        'DisableLocalCredtCardInput' => true,
        'TokenisedStorage' => false,
    );
}
function rupantorpay_link($params)
{
    if (php_sapi_name() === 'cli') {
        return '';
    }
    $currentPage = basename(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH), ".php");
    if (isset($_POST['pay'])) {
        $response = rupantorpay_payment_url($params);
        if (!empty($response['status']) && !empty($response['payment_url'])) {
            header('Location: ' . $response['payment_url']);
            exit();
        }
        return '<div class="alert alert-danger mt-2">' . htmlspecialchars($response['message']) . '</div>';
    }
    $statusMessage = '';
    if (isset($_GET['status'])) {
        $status = $_GET['status'];
        if ($status == 'failed') {
            $statusMessage = '<div class="alert alert-danger mt-2">Payment has been cancelled</div>';
        } elseif ($status == 'pending') {
            $statusMessage = '<div class="alert alert-warning mt-2">Your payment is currently under verification. Please wait while we process it.</div>';
        } elseif ($status == 'success' || $status == 'completed') {
            $statusMessage = '<div class="alert alert-success mt-2">Payment Successful</div>';
        }
    }
    if ($currentPage == "viewinvoice") {
        return '<form action="" method="POST">
            <input class="btn btn-primary" name="pay" type="submit" value="' . htmlspecialchars($params['langpaynow']) . '" />
        </form>' . $statusMessage;
    } else {
        $response = rupantorpay_payment_url($params);
        if (!empty($response['status']) && !empty($response['payment_url'])) {
            return '<form action="' . htmlspecialchars($response['payment_url']) . '" method="GET">
                <input class="btn btn-primary" type="submit" value="' . htmlspecialchars($params['langpaynow']) . '" />
            </form>' . $statusMessage;
        }
        return '<div class="alert alert-danger mt-2">' . htmlspecialchars($response['message']) . '</div>' . $statusMessage;
    }
}

function rupantorpay_config()
{
    return array(
        'FriendlyName' => array(
            'Type' => 'System',
            'Value' => 'rupantorpay',
        ),
        'apiKey' => array(
            'FriendlyName' => 'Api Key',
            'Type' => 'text',
            'Size' => '150',
            'Default' => '',
            'Description' => 'Enter Your Api Key',
        ),

        'currency_rate' => array(
            'FriendlyName' => 'Exchange Rate [1 USD = ? BDT]',
            'Type' => 'text',
            'Size' => '150',
            'Default' => '120',
            'Description' => 'Enter Dollar Rate',
        )
    );
}

function rupantorpay_payment_url($params)
{
    $fullname = $params['clientdetails']['firstname'] . " " . $params['clientdetails']['lastname'];
    $email = $params['clientdetails']['email'];
    $apikey = $params['apiKey'];
    $currency_rate = $params['currency_rate'];
    $invoiceId = $params['invoiceid'];
    if ($params['currency'] == "USD") {
        $amount = $params['amount'] * $currency_rate;
    } else {
        $amount = $params['amount'];
    }
    if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on')
        $url = "https://";
    else
        $url = "http://";
    $url .= $_SERVER['HTTP_HOST'];

    $systemUrl = $url;
    $clientDomain = $_SERVER['HTTP_HOST'];
    $webhook_url = $systemUrl . '/modules/gateways/callback/rupantorpay.php?api=' . $apikey . '&invoice=' . $invoiceId;
    $success_url = $systemUrl . '/viewinvoice.php?id=' . $invoiceId;
    $cancel_url = $systemUrl . '/viewinvoice.php?id=' . $invoiceId;
    $data   = array(
        "fullname"          => $fullname,
        "email"         => $email,
        "amount"            => $amount,
        "webhook_url"       => $webhook_url,
        "success_url"       => $success_url,
        "cancel_url"        => $cancel_url,
    );
    $header   = array(
        "api"               => $apikey,
        "url"               => 'https://payment.rupantorpay.com/api/payment/checkout',
    );
    
    $headers = array(
        'Content-Type: application/json',
        'X-API-KEY: ' . $header['api'],
         "X-CLIENT: " . $clientDomain,
    );
    $url = $header['url'];
    $curl = curl_init();
    $data = json_encode($data);
    curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_2_0,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $data,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_VERBOSE => true
    ));
    $response = curl_exec($curl);
    curl_close($curl);
    $res = json_decode($response, true);
    if ($res['status'] && $res['payment_url']) {
        header('Location: ' . $res['payment_url']);
        exit();
    } else {
        echo $res['message'];
    }
}