<?php
/* rupantorpay WHMCS Gateway
     *
     * Copyright (c) 2022 rupantorpay
     * Website: https://rupantorpay.com
     * Developer: rupantorpay LTD
     */

require_once __DIR__ . '/../../../init.php';
require_once __DIR__ . '/../../../includes/gatewayfunctions.php';
require_once __DIR__ . '/../../../includes/invoicefunctions.php';

use WHMCS\Config\Setting;

$invoiceId = $_REQUEST['invoice'];
$transactionId = $_REQUEST['transactionId'];
$paymentAmount = $_REQUEST['paymentAmount'];
$paymentFee = $_REQUEST['paymentFee'];
$paymentMethod = $_REQUEST['paymentMethod'] ?? '';
$gatewayModuleName = "rupantorpay";
$gatewayParams = getGatewayVariables($gatewayModuleName);
if (strtolower($paymentMethod) === 'binance') {
    $currencyRate = $gatewayParams['currency_rate'] ?? 120;
    $paymentAmount = $paymentAmount / $currencyRate;
}

$transaction_id_rupantorpay = $transactionId;

$data = [
    "transaction_id" => $transaction_id_rupantorpay,
];

$apikey = $_GET['api'];
$header = [
    "api" => $apikey,
    "url" => 'https://payment.rupantorpay.com/api/payment/verify-payment',
];

$headers = [
    'Content-Type: application/json',
    'X-API-KEY: ' . $header['api'],
];

$url = $header['url'];
$curl = curl_init();
$data = json_encode($data);
curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS => $data,
    CURLOPT_HTTPHEADER => $headers,
]);


$response = curl_exec($curl);
curl_close($curl);
$data = json_decode($response, true);

if ($data['status'] == "COMPLETED") {
    addInvoicePayment(
        $invoiceId,
        $transactionId,
        $paymentAmount,
        $paymentFee,
        $gatewayModuleName
    );


    $systemUrl = Setting::getValue('SystemURL');
    echo "<script>
            location.href = \"{$systemUrl}/viewinvoice.php?id={$invoiceId}\";
          </script>";
} elseif ($data['status'] == "PENDING") {
    echo "Your payment is currently pending. Please check back later.";
} else {
    echo "Failed. Id Not Match";
}
?>
